﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.BusinessManager.TBI;
using BusinessHelper = VeteransAffairs.Registries.Business.Utilities.Helpers;

public partial class TBI_Instruments_MayoPortlandAdaptabilityInventory4 : BaseTBIInstrumentPage
{

    #region Variable Declarations

    private const string FailedFormValuesName = "MPAI4FailedFormValues";
    private const string DeferredMessageKeyName = "MPAI4DeferredMessageKey";
    private const string ValidationQRPTErrorMessageKeyName = "MPAI4ValidationQRPTErrorKey";
    private const string Validation28ABErrorMessageKeyName = "MPAI4Validation28ABErrorKey";
    protected int _surveyTypeId = 19; //Database Id for Mayo-Portland

    PatientManager patientManager = new PatientManager();
    InstrumentType instrumentType = new InstrumentType();

    SURVEY _survey;   //the root object in the Survey set

    List<STD_QUESTION> QuestionList = new List<STD_QUESTION>();  

    #endregion

    #region Public Methods

    /// <summary>
    /// Default Constructor
    /// </summary>
    public TBI_Instruments_MayoPortlandAdaptabilityInventory4()
    {
        //Manager Save Notification Event Handler
        patientManager.BOSaveSuccess += manager_BOSaveSuccess;
    }

    #endregion

    #region Protected Methods

    protected void Page_Init(object sender, EventArgs e)
    {
        VeteransAffairs.Registries.QuestionChoiceRetriever.Reset(_tbiInstrumentManager, _surveyTypeId);
    }

    protected void Page_Unload(object sender, EventArgs e)
    {
        VeteransAffairs.Registries.QuestionChoiceRetriever.Reset(null, -1);
    }

    bool preventNotification = false;
    protected void Page_PreRenderComplete(object sender, EventArgs e)
    {
        Dictionary<string, string> cache;
        string validationQRPTError = ValidationQRPTErrorMessage;
        string validation28ABError = Validation28ABErrorMessage;
        if (!Page.IsPostBack && (!String.IsNullOrEmpty(validationQRPTError) || !String.IsNullOrEmpty(validation28ABError)))
        {
            lblErrorQRPT1.Text = validationQRPTError;
            lblError28AB.Text = validation28ABError;
            ValidationQRPTErrorMessage = null;
            Validation28ABErrorMessage = null;
            SuppressSaveMessage = false;
            SaveFailMessage = "Unable to save the survey.\r\n\r\nPlease correct the validation errors and try to submit your changes again.";
            RenderStartUpMessage(false);
        }
        //else if (!Page.IsPostBack && Helpers.SetupPageFromCache(this, FailedFormValuesName, out cache))
        //{
        //    ctrlDiagnosis.ReadFromCache(cache);
        //    RestoreDateFromCache("D", cache);
        //    SuppressSaveMessage = false;
        //    SaveFailMessage = "Unable to save the survey.\r\n\r\nThere may be network issues preventing you from saving.\r\n\r\nPlease try to submit your changes again.";
        //    RenderStartUpMessage(false);
        //}
        else if (Page.IsPostBack && !preventNotification)
        {
            DeferredMessage = "Save was Successful!";
        }
        else if (DeferredMessage != null)
        {
            SuppressSaveMessage = false;
            SaveSuccessMessage = DeferredMessage;
            RenderStartUpMessage(true);
            DeferredMessage = null;
        }
        plxhldrQ28B1.Visible = rblQ28B.SelectedIndex != -1;
    }

    private static string ValidationQRPTErrorMessage
    {
        get { return HttpContext.Current.Session[ValidationQRPTErrorMessageKeyName] as string; }
        set 
        {
            if (String.IsNullOrEmpty(value))
            {
                HttpContext.Current.Session.Remove(ValidationQRPTErrorMessageKeyName);
            }
            else
            {
                HttpContext.Current.Session[ValidationQRPTErrorMessageKeyName] = value;
            }
        }
    }

    private static string Validation28ABErrorMessage
    {
        get { return HttpContext.Current.Session[Validation28ABErrorMessageKeyName] as string; }
        set
        {
            if (String.IsNullOrEmpty(value))
            {
                HttpContext.Current.Session.Remove(Validation28ABErrorMessageKeyName);
            }
            else
            {
                HttpContext.Current.Session[Validation28ABErrorMessageKeyName] = value;
            }
        }
    }

    private void RestoreDateFromCache(string questionNumber, Dictionary<string, string> cache)
    {
        string dateString;
        if (cache.TryGetValue(questionNumber, out dateString))
        {
            dpDate1.SelectedDate = dpDate1.FocusedDate = DateTime.Parse(dateString);
        }
    }

    private static string DeferredMessage
    {
        get { return HttpContext.Current.Session[DeferredMessageKeyName] as string; }
        set { HttpContext.Current.Session[DeferredMessageKeyName] = value; }
    }

    /// <summary>
    /// Page Load method
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void Page_Load(object sender, EventArgs e)
    {
        try
        {
            _tbiInstrumentManager.TbiServiceTo = base.GetTBIServiceTo();
            if (_tbiInstrumentManager.TbiServiceTo == null)
            {
                Logging.WriteLogToFile("MayoPortlandAdaptabilityInventory4.Page_Load(): WarningRedirect: _tbiInstrumentManager.TbiServiceTo == null", true);
                //Redirect to message that session is ended and need to log back in from CPRS.
                Response.Redirect("Warning.aspx?err=2");
            }

            string instTitle = _tbiInstrumentManager.GetInstrumentByID(_surveyTypeId).Name;

            LabelBreadCrumb.Text = "TBI Instruments > Instrument Associations > " + instTitle;
            LabelInstrumentTitle.Text = instTitle;
            Page.Title = "TBI Instruments - " + instTitle;
            //SetQuestionLabels();

            Label labelUser = (Label)Master.FindControl("LabelCurrentUser");
            labelUser.Text = BusinessHelper.FixStringToPreventXss(_tbiInstrumentManager.TbiServiceTo.UserName);
            LabelPatient.Text = BusinessHelper.FixStringToPreventXss(_tbiInstrumentManager.TbiServiceTo.PatientName);
            LabelSSN.Text = BusinessHelper.FixStringToPreventXss(_tbiInstrumentManager.TbiServiceTo.PatientSnum);
            if (!IsPostBack)
            {
                base.AddtoViewStateTBIServiceTo(_tbiInstrumentManager.TbiServiceTo);

                if (instrumentType.Status != null)
                {
                    _tbiInstrumentManager.TbiServiceTo.SelectedInstrumentType = instrumentType;
                }

                string _snum = _tbiInstrumentManager.TbiServiceTo.PatientSnum;
                if (!string.IsNullOrEmpty(_snum))
                {
                    string patICN = patientManager.GetPatientICNBySnum(_snum);

                    if (!string.IsNullOrEmpty(patICN))
                    {
                        ViewState["PatientICN"] = patICN;
                        RefreshSurvey(patICN);
                    }
                    else
                    {
                        throw new ArgumentException("Patient with this SSN does not exist.");
                    }

                    if (_survey != null && !_survey.isNew)
                    {
                        SetUpSurvey(_survey);
                        //calculateTotal();
                    }
                    string referrer = "";
                    if (Request.UrlReferrer != null)
                    {
                        referrer = Request.UrlReferrer.PathAndQuery;
                    }
                    ViewState["referrer"] = referrer;
                }
                LabelPatient.Text = BusinessHelper.FixStringToPreventXss(_tbiInstrumentManager.TbiServiceTo.PatientName);
                LabelSSN.Text = BusinessHelper.FixStringToPreventXss(_tbiInstrumentManager.TbiServiceTo.PatientSnum.Trim().Length == 9 ? String.Format("{0:000-00-0000}", int.Parse(_tbiInstrumentManager.TbiServiceTo.PatientSnum)) : _tbiInstrumentManager.TbiServiceTo.PatientSnum);
                lblErrorQRPT1.Text = "";
                lblError28AB.Text = "";
            }
            QuestionList = VeteransAffairs.Registries.QuestionChoiceRetriever.GetQuestions(); // GetAllQuestionsForSurvey();
            SetQuestionLabels();

            dpDate1.MaxDate = DateTime.Now;
        }
        catch (Exception ex)
        {
            //Redirect to message that session is ended and need to log back in from CPRS.
            Exception _tbilogerror = HandleTBIException(ex, "MayoPortlandAdaptabilityInventory4.aspx", "100027", "SESSIOENDED");
            Response.Redirect("Warning.aspx?err=2");
        }
    }

    private void SetQuestionLabels()
    {
        // Set control values for Diagnosis Question
        ctrlDiagnosis.QuestionText = GetQuestionText("DX");
        ctrlDiagnosis.SurveyTypeCode = HiddenSurveyType.Value;

        LabelDate1.Text = GetQuestionText("D");
        LabelForQRPT.Text = GetQuestionText("QRPT");
        //LabelForQRPT1.Text = GetQuestionText("QRPT1");
        LabelForQ1.Text = GetQuestionText("1");
        LabelForQ2.Text = GetQuestionText("2");
        LabelForQ3.Text = GetQuestionText("3");
        LabelForQ4.Text = GetQuestionText("4");
        LabelForQ5.Text = GetQuestionText("5");
        LabelForQ6.Text = GetQuestionText("6");
        LabelForQ7A.Text = GetQuestionText("7A");
        LabelForQ7B.Text = GetQuestionText("7B");
        LabelForQ8.Text = GetQuestionText("8");
        LabelForQ9.Text = GetQuestionText("9");
        LabelForQ10.Text = GetQuestionText("10");
        LabelForQ11.Text = GetQuestionText("11");
        LabelForQ12.Text = GetQuestionText("12");
        LabelForQ13.Text = GetQuestionText("13");
        LabelForQ14.Text = GetQuestionText("14");
        LabelForQ15.Text = GetQuestionText("15");
        LabelForQ16.Text = GetQuestionText("16");
        LabelForQ17.Text = GetQuestionText("17");
        LabelForQ18.Text = GetQuestionText("18");
        LabelForQ19.Text = GetQuestionText("19");
        LabelForQ20.Text = GetQuestionText("20");
        LabelForQ21.Text = GetQuestionText("21");
        LabelForQ22.Text = GetQuestionText("22");
        LabelForQ23.Text = GetQuestionText("23");
        LabelForQ24.Text = GetQuestionText("24");
        LabelForQ25.Text = GetQuestionText("25");
        LabelForQ26.Text = GetQuestionText("26");
        LabelForQ27.Text = GetQuestionText("27");
        LabelForQ28A.Text = GetQuestionText("28A");
        LabelForQ28B.Text = GetQuestionText("28B");
        LabelForQ28B1.Text = GetQuestionText("28B1");
        LabelForQ29.Text = GetQuestionText("29");
        LabelForQ30PRE.Text = GetQuestionText("30PRE");
        LabelForQ30POST.Text = GetQuestionText("30POST");
        LabelForQ31PRE.Text = GetQuestionText("31PRE");
        LabelForQ31POST.Text = GetQuestionText("31POST");
        LabelForQ32PRE.Text = GetQuestionText("32PRE");
        LabelForQ32POST.Text = GetQuestionText("32POST");
        LabelForQ33PRE.Text = GetQuestionText("33PRE");
        LabelForQ33POST.Text = GetQuestionText("33POST");
        LabelForQ34PRE.Text = GetQuestionText("34PRE");
        LabelForQ34POST.Text = GetQuestionText("34POST");
        LabelForQ35PRE.Text = GetQuestionText("35PRE");
        LabelForQ35POST.Text = GetQuestionText("35POST");
        LabelForQ36Comment.Text = GetQuestionText("36");
        LabelForQ37.Text = GetQuestionText("37");
        LabelForQ38.Text = GetQuestionText("38");
        LabelForQ39.Text = GetQuestionText("39");
        LabelForQ40.Text = GetQuestionText("40");
        LabelForQ41.Text = GetQuestionText("41");
        LabelForQ42.Text = GetQuestionText("42");
        LabelForQ43.Text = GetQuestionText("43");
        LabelForQ44.Text = GetQuestionText("44");
        LabelForQ45.Text = GetQuestionText("45");
        LabelForQ46.Text = GetQuestionText("46");
    }

    protected void Q28aOnSelectedIndexChanged(object sender, EventArgs e)
    {
        rblQ28B.SelectedIndex = -1;
        rblQ28B1.SelectedIndex = -1;
        plxhldrQ28B1.Visible = false;
    }

    protected void Q28bOnSelectedIndexChanged(object sender, EventArgs e)
    {
        rblQ28A.SelectedIndex = -1;
        plxhldrQ28B1.Visible = true;
    }

    protected override void LoadViewState(object savedState)
    {
        base.LoadViewState(savedState);
        string surveyXml = (string)ViewState["surveyXml"];
        _survey = SerializerUtil.Deserialize<SURVEY>(surveyXml);
    }

    protected override object SaveViewState()
    {
        ViewState["surveyXml"] = _survey.Serialize();
        return base.SaveViewState();
    }

    /// <summary>
    /// Returns the Question_Text of the question with the passed Question_Number field
    /// </summary>
    /// <param name="questionId"></param>
    /// <returns></returns>
    protected string GetQuestionText(string questionId)
    {
        foreach (STD_QUESTION ques in QuestionList)
        {
            if (ques.QUESTION_NUMBER.ToLower() == questionId.ToLower())
            {
                return ques.QUESTION_TEXT;
            }
        }
        return "";
    }

    /// <summary>
    /// Returns the Question_Id of the question with the passed Question_Number field
    /// </summary>
    /// <param name="questionId"></param>
    /// <returns></returns>
    protected int GetQuestionId(string questionNumber)
    {
        foreach (STD_QUESTION ques in QuestionList)
        {
            if (ques.QUESTION_NUMBER.ToLower() == questionNumber.ToLower())
            {
                return ques.ID;
            }
        }
        return 0;
    }

    /// <summary>
    /// Save Draft button clicked.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    public void btnSaveSurveyDraft_Click(object sender, EventArgs e)
    {
        Int32 status = 0;
        SaveFailMessage = "Save Failed. Please press " + btnSaveSurveyDraft.Text + " button again to avoid data loss.";
        SaveCompleteSurvey(ref status);
        Response.Redirect(Request.Url.PathAndQuery, false);
    }

    /// <summary>
    /// Save and Prepare Note button clicked.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnSubmit_Click(object sender, EventArgs e)
    {
        Int32 status = 0;
        SaveFailMessage = "Save Failed. Please press " + btnSubmitSurvey.Text + " button again to avoid data loss.";
        Page.Validate();
        bool isQRPT1Valid = IsQRPT1Valid();
        bool is28ABValid = Is28ABValid();
        SaveCompleteSurvey(ref status);

        if (Page.IsValid && isQRPT1Valid && is28ABValid && status > 0)
        {
            preventNotification = true;
            Session["survey"] = _survey;
            Response.Redirect("InstrumentSummaryNote.aspx", false);
        }
        else
        {
            Response.Redirect(Request.Url.PathAndQuery, false);
        }
    }

    /// <summary>
    /// Inactive timer firing.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void InActiveTimer_Tick(object sender, EventArgs e)
    {
        preventNotification = true;
        Int32 status = 0;
        SaveFailMessage = "Save Failed. Please press " + btnSaveSurveyDraft.Text + " button again to avoid data loss.";
        SaveCompleteSurvey(ref status);
        Response.Redirect(Request.Url.PathAndQuery, false);
    }

    /// <summary>
    /// Cancel button clicked.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnCancel_Click(object sender, EventArgs e)
    {
        ViewState["surveyXml"] = null;
        ViewState["PatientICN"] = null;
        ViewState["referrer"] = null;
        Session.Remove("survey");
        Response.Redirect("Instrument.aspx", false);
    }

    /// <summary>
    /// Hide or Show instructions
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void lnkBtnToggleInstructions_OnClick(object sender, EventArgs e)
    {
        lnkBtnToggleInstructions.Text = PanelInstructions.Visible ? "Click for Instructions" : "Hide Instructions";
        PanelInstructions.Visible = !PanelInstructions.Visible;
    }

    /// <summary>
    /// Calculate button clicked.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnCalculate_Click(object sender, EventArgs e)
    {
        calculateTotal();
    }

    protected void SetTotal(RadioButtonList list, STD_QUESTION question, ref double totalToSet, ref bool isSurveyCompletelyFilledOut)
    {
        if (!String.IsNullOrEmpty(list.SelectedValue))
        {
            STD_QUESTION_CHOICE choice = question.STD_QUESTION_CHOICEs.FirstOrDefault(C => C.CHOICE_TEXT.ToLower() == list.SelectedItem.Text.ToLower());
            if (choice != null)
            {
                totalToSet = Convert.ToDouble(choice.CHOICE_NAME);
            }
        }
        else
        {
            isSurveyCompletelyFilledOut = false;
        }
    }

    protected void UpdateTotal(RadioButtonList list, STD_QUESTION question, ref double totalToUpdate, ref bool isSurveyCompletelyFilledOut)
    {
        if (!String.IsNullOrEmpty(list.SelectedValue))
        {
            STD_QUESTION_CHOICE choice = question.STD_QUESTION_CHOICEs.FirstOrDefault(C => C.CHOICE_TEXT.ToLower() == list.SelectedItem.Text.ToLower());
            if (choice != null)
            {
                totalToUpdate += Convert.ToDouble(choice.CHOICE_NAME);
            }
        }
        else
        {
            isSurveyCompletelyFilledOut = false;
        }
    }

    protected void Update3Totals(RadioButtonList list, STD_QUESTION question, ref double totalToUpdate1, ref double totalToUpdate2, ref double totalToUpdate3, ref bool isSurveyCompletelyFilledOut)
    {
        if (!String.IsNullOrEmpty(list.SelectedValue))
        {
            STD_QUESTION_CHOICE choice = question.STD_QUESTION_CHOICEs.FirstOrDefault(C => C.CHOICE_TEXT.ToLower() == list.SelectedItem.Text.ToLower());
            if (choice != null)
            {
                totalToUpdate1 += Convert.ToDouble(choice.CHOICE_NAME);
                totalToUpdate2 += Convert.ToDouble(choice.CHOICE_NAME);
                totalToUpdate3 += Convert.ToDouble(choice.CHOICE_NAME);
            }
        }
        else
        {
            isSurveyCompletelyFilledOut = false;
        }
    }

    protected void UpdateTotalForQ4(RadioButtonList list, STD_QUESTION question, ref double totalToUpdate, ref bool isSurveyCompletelyFilledOut)
    {
        double q4score = 0;
        double q4newScore = 0;
        if (!String.IsNullOrEmpty(list.SelectedValue))
        {
            STD_QUESTION_CHOICE choice = question.STD_QUESTION_CHOICEs.FirstOrDefault(C => C.CHOICE_TEXT.ToLower() == list.SelectedItem.Text.ToLower());
            if (choice != null)
            {
                q4score = Convert.ToDouble(choice.CHOICE_NAME);
                if (q4score == 0)
                {
                    q4newScore = 0;
                }
                else if ((q4score == 1) || (q4score == 2) || (q4score == 3))
                {
                    q4newScore = 1;
                }
                else if (q4score == 4)
                {
                    q4newScore = 3;
                }
                totalToUpdate += q4newScore;
            }
        }
        else
        {
            isSurveyCompletelyFilledOut = false;
        }
    }

    protected void UpdateTotalForQ16(RadioButtonList list, STD_QUESTION question, ref double totalToUpdate, ref bool isSurveyCompletelyFilledOut)
    {
        double q16score = 0;
        double q16newScore = 0;
        if (!String.IsNullOrEmpty(list.SelectedValue))
        {
            STD_QUESTION_CHOICE choice = question.STD_QUESTION_CHOICEs.FirstOrDefault(C => C.CHOICE_TEXT.ToLower() == list.SelectedItem.Text.ToLower());
            if (choice != null)
            {
                q16score = Convert.ToDouble(choice.CHOICE_NAME);
                if (q16score == 0)
                {
                    q16newScore = 0;
                }
                else if ((q16score == 1) || (q16score == 2))
                {
                    q16newScore = 1;
                }
                else if ((q16score == 3) || (q16score == 4))
                {
                    q16newScore = 2;
                }
                totalToUpdate += q16newScore;
            }
        }
        else
        {
            isSurveyCompletelyFilledOut = false;
        }
    }

    protected void UpdateTotalForQ27(RadioButtonList list, STD_QUESTION question, ref double totalToUpdate, ref bool isSurveyCompletelyFilledOut)
    {
        double q27score = 0;
        double q27newScore = 0;
        if (!String.IsNullOrEmpty(list.SelectedValue))
        {
            STD_QUESTION_CHOICE choice = question.STD_QUESTION_CHOICEs.FirstOrDefault(C => C.CHOICE_TEXT.ToLower() == list.SelectedItem.Text.ToLower());
            if (choice != null)
            {
                q27score = Convert.ToDouble(choice.CHOICE_NAME);
                if ((q27score == 0) || (q27score == 1))
                {
                    q27newScore = 0;
                }
                else if ((q27score == 2) || (q27score == 3))
                {
                    q27newScore = 1;
                }
                else if (q27score == 4)
                {
                    q27newScore = 3;
                }
                totalToUpdate += q27newScore;
            }
        }
        else
        {
            isSurveyCompletelyFilledOut = false;
        }
    }

    /// <summary>
    /// Calculate total score.
    /// </summary>
    protected void calculateTotal()
    {
        bool isSurveyCompletelyFilledOut = true;
        bool unusedCompleteFlag = true;

        double abilitySubTotal = 0;
        double adjustmentSubTotal = 0;
        double participationSubTotal = 0;
        double subtotalOfSubscaleScores = 0;
        double subTotal22to24 = 0;
        double total = 0;
        double abilitiesStandardScore = 0;
        double adjustmentStandardScore = 0;
        double participationStandardScore = 0;
        double totalStandardScore = 0;

        double q7aScore = 0;
        double q7bScore = 0;

        foreach (STD_QUESTION question in QuestionList)
        {
            switch (question.QUESTION_NUMBER)
            {
                // Ability Subscale
                case "1": UpdateTotal(rblQ1, question, ref abilitySubTotal, ref isSurveyCompletelyFilledOut); break;
                case "2": UpdateTotal(rblQ2, question, ref abilitySubTotal, ref isSurveyCompletelyFilledOut); break;
                case "3": UpdateTotal(rblQ3, question, ref abilitySubTotal, ref isSurveyCompletelyFilledOut); break;
                case "4": UpdateTotalForQ4(rblQ4, question, ref abilitySubTotal, ref isSurveyCompletelyFilledOut); break;
                case "5": UpdateTotal(rblQ5, question, ref abilitySubTotal, ref isSurveyCompletelyFilledOut); break;
                case "6": UpdateTotal(rblQ6, question, ref abilitySubTotal, ref isSurveyCompletelyFilledOut); break;
                case "7A": SetTotal(rblQ7A, question, ref q7aScore, ref isSurveyCompletelyFilledOut); break;
                case "7B": SetTotal(rblQ7B, question, ref q7bScore, ref isSurveyCompletelyFilledOut); break;
                case "8": UpdateTotal(rblQ8, question, ref abilitySubTotal, ref isSurveyCompletelyFilledOut); break;
                case "9": UpdateTotal(rblQ9, question, ref abilitySubTotal, ref isSurveyCompletelyFilledOut); break;
                case "10": UpdateTotal(rblQ10, question, ref abilitySubTotal, ref isSurveyCompletelyFilledOut); break;
                case "11": UpdateTotal(rblQ11, question, ref abilitySubTotal, ref isSurveyCompletelyFilledOut); break;
                case "12": UpdateTotal(rblQ12, question, ref abilitySubTotal, ref isSurveyCompletelyFilledOut); break;

                // Adjustment Subscale
                case "13": UpdateTotal(rblQ13, question, ref adjustmentSubTotal, ref isSurveyCompletelyFilledOut); break;
                case "14": UpdateTotal(rblQ14, question, ref adjustmentSubTotal, ref isSurveyCompletelyFilledOut); break;
                case "15": UpdateTotal(rblQ15, question, ref adjustmentSubTotal, ref isSurveyCompletelyFilledOut); break;
                case "16": UpdateTotalForQ16(rblQ16, question, ref adjustmentSubTotal, ref isSurveyCompletelyFilledOut); break;
                case "17": UpdateTotal(rblQ17, question, ref adjustmentSubTotal, ref isSurveyCompletelyFilledOut); break;
                case "18": UpdateTotal(rblQ18, question, ref adjustmentSubTotal, ref isSurveyCompletelyFilledOut); break;
                case "19": UpdateTotal(rblQ19, question, ref adjustmentSubTotal, ref isSurveyCompletelyFilledOut); break;
                case "20": UpdateTotal(rblQ20, question, ref adjustmentSubTotal, ref isSurveyCompletelyFilledOut); break;
                case "21": UpdateTotal(rblQ21, question, ref adjustmentSubTotal, ref isSurveyCompletelyFilledOut); break;

                // Both Adjustment and Participation Subscale
                case "22": Update3Totals(rblQ22, question, ref adjustmentSubTotal, ref participationSubTotal, ref subTotal22to24, ref isSurveyCompletelyFilledOut); break;
                case "23": Update3Totals(rblQ23, question, ref adjustmentSubTotal, ref participationSubTotal, ref subTotal22to24, ref isSurveyCompletelyFilledOut); break;
                case "24": Update3Totals(rblQ24, question, ref adjustmentSubTotal, ref participationSubTotal, ref subTotal22to24, ref isSurveyCompletelyFilledOut); break;

                // Participation-only Subscale
                case "25": UpdateTotal(rblQ25, question, ref participationSubTotal, ref isSurveyCompletelyFilledOut); break;
                case "26": UpdateTotal(rblQ26, question, ref participationSubTotal, ref isSurveyCompletelyFilledOut); break;
                case "27": UpdateTotalForQ27(rblQ27, question, ref participationSubTotal, ref isSurveyCompletelyFilledOut); break;
                case "28A": UpdateTotal(rblQ28A, question, ref participationSubTotal, ref unusedCompleteFlag); break;
                case "28B": UpdateTotal(rblQ28B, question, ref participationSubTotal, ref unusedCompleteFlag); break;
                case "28B1": UpdateTotal(rblQ28B1, question, ref participationSubTotal, ref unusedCompleteFlag); break;
                case "29": UpdateTotal(rblQ29, question, ref participationSubTotal, ref isSurveyCompletelyFilledOut); break;
                default: break;
            }
        }
        abilitySubTotal += Math.Max(q7aScore, q7bScore);  // use highest score from 7A or 7B

        subtotalOfSubscaleScores = abilitySubTotal + adjustmentSubTotal + participationSubTotal;
        total = subtotalOfSubscaleScores - subTotal22to24;

        abilitiesStandardScore = getAbilitiesStandardScore(abilitySubTotal);
        adjustmentStandardScore = getAdjustmentStandardScore(adjustmentSubTotal);
        participationStandardScore = getParticipationStandardScore(participationSubTotal);
        totalStandardScore = getTotalStandardScore(total);


        lblAbilitySubTotal.Text = abilitySubTotal.ToString();
        lblAdjustmentSubTotal.Text = adjustmentSubTotal.ToString();
        lblParticipationSubTotal.Text = participationSubTotal.ToString();
        lblSubtotalOfSubscaleScores.Text = subtotalOfSubscaleScores.ToString();
        lblSumOfScoresQ22_24.Text = subTotal22to24.ToString();
        lblTotalScore.Text = total.ToString();
        lblAbilitiesStandardScore.Text = abilitiesStandardScore.ToString();
        lblAdjustmentStandardScore.Text = adjustmentStandardScore.ToString();
        lblParticipationStandardScore.Text = participationStandardScore.ToString();
        lblTotalStandardScore.Text = totalStandardScore.ToString();

        if (isSurveyCompletelyFilledOut)
        {
            lblSurveyError.Text = "";
        }
        else
        {
            // ERROR ... 
            lblSurveyError.Text = "ERROR: Survey is not completed."; // TODO - Alert error.
        }
    }

    #endregion

    #region Private Methods

    /// <summary>
    /// Converts Ability Raw Score into Standard Score, based on Reference Tables (MPAI-4 Manual)
    /// </summary>
    /// <param name="abilitySubTotal"></param>
    /// <returns></returns>
    private double getAbilitiesStandardScore(double abilitySubTotal)
    {
        int intAbilitySubTotal = 0;
        try
        {
            intAbilitySubTotal = Convert.ToInt32(abilitySubTotal);
        }
        catch
        {
            return 0;
        }
        switch (intAbilitySubTotal)
        {
            case 0: return -4;
            case 1: return 12;
            case 2: return 21;
            case 3: return 25;
            case 4: return 29;
            case 5: return 31;
            case 6: return 34;
            case 7: return 35;
            case 8: return 37;
            case 9: return 39;
            case 10: return 40;
            case 11: return 41;
            case 12: return 42;
            case 13: return 44;
            case 14: return 45;
            case 15: return 46;
            case 16: return 47;
            case 17: return 48;
            case 18: return 49;
            case 19: return 50;
            case 20: return 51;
            case 21: return 52;
            case 22: return 53;
            case 23: return 54;
            case 24: return 55;
            case 25: return 56;
            case 26: return 57;
            case 27: return 58;
            case 28: return 59;
            case 29: return 60;
            case 30: return 61;
            case 31: return 62;
            case 32: return 63;
            case 33: return 65;
            case 34: return 66;
            case 35: return 68;
            case 36: return 69;
            case 37: return 71;
            case 38: return 73;
            case 39: return 74;
            case 40: return 77;
            case 41: return 79;
            case 42: return 81;
            case 43: return 84;
            case 44: return 88;
            case 45: return 92;
            case 46: return 99;
            case 47: return 109;
            default: return 0;
        }
    }

    /// <summary>
    /// Converts Adjustment Raw Score into Standard Score, based on Reference Tables (MPAI-4 Manual)
    /// </summary>
    /// <param name="adjustmentSubTotal"></param>
    /// <returns></returns>
    private double getAdjustmentStandardScore(double adjustmentSubTotal)
    {
        int intAdjustmentSubTotal = 0;
        try
        {
            intAdjustmentSubTotal = Convert.ToInt32(adjustmentSubTotal);
        }
        catch
        {
            return 0;
        }
        switch (intAdjustmentSubTotal)
        {
            case 0: return -6;
            case 1: return 10;
            case 2: return 19;
            case 3: return 24;
            case 4: return 28;
            case 5: return 30;
            case 6: return 33;
            case 7: return 35;
            case 8: return 36;
            case 9: return 38;
            case 10: return 39;
            case 11: return 41;
            case 12: return 42;
            case 13: return 43;
            case 14: return 44;
            case 15: return 45;
            case 16: return 46;
            case 17: return 47;
            case 18: return 48;
            case 19: return 49;
            case 20: return 50;
            case 21: return 51;
            case 22: return 52;
            case 23: return 53;
            case 24: return 54;
            case 25: return 55;
            case 26: return 55;
            case 27: return 56;
            case 28: return 57;
            case 29: return 58;
            case 30: return 59;
            case 31: return 60;
            case 32: return 62;
            case 33: return 63;
            case 34: return 64;
            case 35: return 65;
            case 36: return 67;
            case 37: return 68;
            case 38: return 70;
            case 39: return 71;
            case 40: return 73;
            case 41: return 75;
            case 42: return 78;
            case 43: return 80;
            case 44: return 84;
            case 45: return 88;
            case 46: return 94;
            default: return 0;
        }
    }

    /// <summary>
    /// Converts Participation Raw Score into Standard Score, based on Reference Tables (MPAI-4 Manual)
    /// </summary>
    /// <param name="participationSubTotal"></param>
    /// <returns></returns>
    private double getParticipationStandardScore(double participationSubTotal)
    {
        int intParticipationSubTotal = 0;
        try
        {
            intParticipationSubTotal = Convert.ToInt32(participationSubTotal);
        }
        catch
        {
            return 0;
        }
        switch (intParticipationSubTotal)
        {
            case 0: return 7;
            case 1: return 19;
            case 2: return 25;
            case 3: return 28;
            case 4: return 31;
            case 5: return 33;
            case 6: return 34;
            case 7: return 36;
            case 8: return 37;
            case 9: return 38;
            case 10: return 39;
            case 11: return 40;
            case 12: return 41;
            case 13: return 42;
            case 14: return 43;
            case 15: return 44;
            case 16: return 45;
            case 17: return 46;
            case 18: return 47;
            case 19: return 48;
            case 20: return 49;
            case 21: return 50;
            case 22: return 52;
            case 23: return 53;
            case 24: return 55;
            case 25: return 57;
            case 26: return 59;
            case 27: return 62;
            case 28: return 65;
            case 29: return 69;
            case 30: return 74;
            default: return 0;
        }
    }


    /// <summary>
    /// Converts Total Raw Score into Standard Score, based on Reference Tables (MPAI-4 Manual)
    /// </summary>
    /// <param name="totalOfSubscaleScores"></param>
    /// <returns></returns>
    private double getTotalStandardScore(double totalOfSubscaleScores)
    {
        int intTotal = 0;
        try
        {
            intTotal = Convert.ToInt32(totalOfSubscaleScores);
        }
        catch
        {
            return 0;
        }
        switch (intTotal)
        {
            case 0: return -38;
            case 1: return -16;
            case 2: return -4;
            case 3: return 2;
            case 4: return 7;
            case 5: return 11;
            case 6: return 13;
            case 7: return 16;
            case 8: return 18;
            case 9: return 20;
            case 10: return 21;
            case 11: return 23;
            case 12: return 24;
            case 13: return 25;
            case 14: return 26;
            case 15: return 27;
            case 16: return 28;
            case 17: return 29;
            case 18: return 30;
            case 19: return 31;
            case 20: return 32;
            case 21: return 33;
            case 22: return 33;
            case 23: return 34;
            case 24: return 35;
            case 25: return 35;
            case 26: return 36;
            case 27: return 37;
            case 28: return 37;
            case 29: return 38;
            case 30: return 39;
            case 31: return 39;
            case 32: return 40;
            case 33: return 40;
            case 34: return 41;
            case 35: return 41;
            case 36: return 42;
            case 37: return 42;
            case 38: return 43;
            case 39: return 44;
            case 40: return 44;
            case 41: return 45;
            case 42: return 45;
            case 43: return 46;
            case 44: return 46;
            case 45: return 47;
            case 46: return 47;
            case 47: return 47;
            case 48: return 48;
            case 49: return 48;
            case 50: return 49;
            case 51: return 49;
            case 52: return 50;
            case 53: return 50;
            case 54: return 51;
            case 55: return 51;
            case 56: return 52;
            case 57: return 52;
            case 58: return 53;
            case 59: return 53;
            case 60: return 54;
            case 61: return 54;
            case 62: return 55;
            case 63: return 55;
            case 64: return 56;
            case 65: return 56;
            case 66: return 57;
            case 67: return 57;
            case 68: return 58;
            case 69: return 58;
            case 70: return 59;
            case 71: return 59;
            case 72: return 60;
            case 73: return 60;
            case 74: return 61;
            case 75: return 62;
            case 76: return 62;
            case 77: return 63;
            case 78: return 63;
            case 79: return 64;
            case 80: return 65;
            case 81: return 65;
            case 82: return 66;
            case 83: return 67;
            case 84: return 67;
            case 85: return 68;
            case 86: return 69;
            case 87: return 69;
            case 88: return 70;
            case 89: return 71;
            case 90: return 72;
            case 91: return 73;
            case 92: return 74;
            case 93: return 75;
            case 94: return 76;
            case 95: return 77;
            case 96: return 78;
            case 97: return 79;
            case 98: return 80;
            case 99: return 81;
            case 100: return 82;
            case 101: return 84;
            case 102: return 85;
            case 103: return 87;
            case 104: return 88;
            case 105: return 90;
            case 106: return 92;
            case 107: return 94;
            case 108: return 97;
            case 109: return 99;
            case 110: return 102;
            case 111: return 106;
            default: return 0;
        }
    }

    /// <summary>
    /// Refresh Survey
    /// </summary>
    /// <param name="patientICN"></param>
    private void RefreshSurvey(string patientICN)
    {
        var surveys = _tbiInstrumentManager.SelectByPatientICNAndSurveyType(patientICN, _surveyTypeId, true).ToList();

        if (surveys.Count > 0)
        {
            _survey = surveys.First();
        }
        else
        {
            _survey = new SURVEY();
        }
        _survey.SetAsChangeTrackingRoot();
    }

    /// <summary>
    /// Save Complete Survey
    /// </summary>
    /// <param name="status"></param>
    private void SaveCompleteSurvey(ref Int32 status)
    {
        try
        {
            string patientICN = String.Empty;
            status = 0;
            //Retrieve patient's ICN from the session variable
            if (ViewState["PatientICN"] != null)
            {
                patientICN = ViewState["PatientICN"].ToString();
                if (String.IsNullOrEmpty(patientICN.Trim()))
                {
                    Logging.WriteLogToFile("MayoPortlandAdaptabilityInventory4.SaveCompletedSurvey(): WarningRedirect: String.IsNullOrEmpty(patientICN.Trim()", true);
                    //Redirect to message that session is ended and need to log back in from CPRS.
                    Response.Redirect("Warning.aspx?err=2");
                }
            }
            else
            {
                Logging.WriteLogToFile("MayoPortlandAdaptabilityInventory4.SaveCompletedSurvey(): WarningRedirect: ViewState[PatientICN] != null", true);
                //Redirect to message that session is ended and need to log back in from CPRS.
                Response.Redirect("Warning.aspx?err=2");
            }

            if (_survey != null)
            {
                if (_survey.isNew)
                {
                    //Ensure that a concurrent session hasn't already inserted a record for this survey
                    var surveys = _tbiInstrumentManager.SelectByPatientICNAndSurveyType(patientICN, _surveyTypeId, true).ToList();

                    if (surveys.Count > 0)
                    {
                        Logging.WriteLogToFile("MayoPortlandAdaptabilityInventory4.SaveCompleteSurvey(): WarningRedirect: surveys.Count > 0", true);
                        //A concurrent session has already inserted a record for this survey and it is not new anymore.
                        Response.Redirect("Warning.aspx?err=9", false);
                    }
                    else
                    {
                        _survey.SURVEY_STATUS = "inprocess";
                        _survey.SetAsInsertOnSubmit();
                        _survey.patient_ICN = patientICN;
                        _survey.STD_SURVEY_TYPE_ID = _surveyTypeId;

                        // TODO: change to datepicker
                        _survey.SURVEY_DATE = DateTime.Today;

                        //Save survey if it's new before adding any responses
                        SuppressSaveMessage = true;
                        _tbiInstrumentManager.Update(_survey);
                        SuppressSaveMessage = false;

                        RefreshSurvey(patientICN);
                    }
                }

                SaveSurvey(ref _survey);
                _survey.SetAsUpdateOnSubmit();
                status = _tbiInstrumentManager.Update(_survey);
                if (status != 0)
                {
                    ((RegistryInstrumentMaster)Master).SetDirtyFlag(false);
                    RefreshSurvey(patientICN);
                    SuppressSaveMessage = false;
                }
            }
        }
        catch (Exception ex)
        {
            Exception _tbilogerror = HandleTBIException(ex, "MayoPortlandAdaptabilityInventory4.aspx", "100027", "SaveCompleteSurvey()");
        }
        finally
        {
            if (status == 0)
            {
                var cache = Helpers.SavePageToCache(this, FailedFormValuesName);
                ctrlDiagnosis.WriteToCache(cache);
                SaveDateToCache(dpDate1, "D", cache);
            }
            else
                Session[FailedFormValuesName] = null;//clear out the cached version on success
        }
    }

    private static void SaveDateToCache(Telerik.Web.UI.RadDatePicker date, string questionNumber, Dictionary<string, string> cache)
    {
        if (date.SelectedDate != null)
        {
            cache.Add(questionNumber, date.SelectedDate.Value.ToShortDateString());
        }
    }

    private bool IsQRPT1Valid()
    {
        if (rblQRPT.SelectedItem.Text == "Significant Other")
        {
            if (txtQRPT1.Text.Trim().Equals(""))
            {
                //lblErrorQRPT1.Text = "Please specify 'Significant other'";
                ValidationQRPTErrorMessage = "Please specify 'Significant other'";
                return false;
            }
        }
        return true;
    }

    private bool Is28ABValid()
    {
        if ((rblQ28A.SelectedIndex == -1) && (rblQ28B.SelectedIndex == -1))
        {
            Validation28ABErrorMessage = lblError28AB.Text = "Rate either item 28A or 28B to reflect the primary desired social role. Do not rate both. Rate 28A if the primary social role is paid employment. If another social role is primary, rate only 28B.";
            return false;
        }

        if ((rblQ28A.SelectedIndex != -1) && (rblQ28B.SelectedIndex != -1))
        {
            rblQ28A.ClearSelection();
            rblQ28B.ClearSelection();
            Validation28ABErrorMessage = lblError28AB.Text = "Rate either item 28A or 28B to reflect the primary desired social role. Do not rate both. Rate 28A if the primary social role is paid employment. If another social role is primary, rate only 28B.";
            return false;
        }
        if ((rblQ28A.SelectedIndex == -1) && (rblQ28B.SelectedIndex != -1))
        {
            if (rblQ28B1.SelectedIndex == -1)
            {
                Validation28ABErrorMessage = lblError28AB.Text = "Please select primary desired social role (28B1)";
                return false;
            }
        }
        return true;
    }

    private int SelectedDiagnosisID
    {
        get
        {
            string temp = this.ctrlDiagnosis.GetSelectedId();
            if (string.IsNullOrEmpty(temp))
                return 0;
            return Convert.ToInt32(temp);
        }
    }

    private void SaveCustomDiagnosis(SURVEY survey, string questionNumber)
    {
        List<STD_QUESTION_CHOICE> availableChoices = VeteransAffairs.Registries.QuestionChoiceRetriever.GetQuestionChoices(questionNumber);
        SURVEY_RESULT currentResult = survey.SURVEY_RESULTs.FirstOrDefault(item => availableChoices.FirstOrDefault(choice => choice.STD_QUESTION_CHOICE_ID == item.STD_QUESTION_CHOICE_ID) != null);
        string inputText = ctrlDiagnosis.GetSelectedResultText();
        int selectedID = SelectedDiagnosisID;
        if (null != currentResult)
        {
            if (currentResult.STD_QUESTION_CHOICE_ID != selectedID || currentResult.RESULT_TEXT != inputText)
            {
                currentResult.SetAsUpdateOnSubmit();
                currentResult.RESULT_TEXT = inputText;
                currentResult.STD_QUESTION_CHOICE_ID = selectedID;
            }
            else
            {
                currentResult.SetAsNoChangeOnSubmit();
            }
        }
        else if (selectedID > 0)
        {
            SURVEY_RESULT result = new SURVEY_RESULT();
            result.RESULT_TEXT = inputText;
            result.STD_QUESTION_CHOICE_ID = selectedID;
            survey.SURVEY_RESULTs.Add(result);
        }
    }

    private void SaveDate(SURVEY survey, Telerik.Web.UI.RadDatePicker date, string questionNumber)
    {
        string inputText = "";
        if (date.SelectedDate != null)
        {
            inputText = ((DateTime)date.SelectedDate).ToShortDateString();
        }
        SaveText(survey, inputText, questionNumber);
    }

    private void SaveText(SURVEY survey, string text, string questionNumber)
    {
        List<STD_QUESTION_CHOICE> availableChoices = VeteransAffairs.Registries.QuestionChoiceRetriever.GetQuestionChoices(questionNumber);
        SURVEY_RESULT currentResult = survey.SURVEY_RESULTs.FirstOrDefault(item => availableChoices.FirstOrDefault(choice => choice.STD_QUESTION_CHOICE_ID == item.STD_QUESTION_CHOICE_ID) != null);
        string inputText = text;
        if (null != currentResult)
        {
            if (currentResult.RESULT_TEXT != inputText)
            {
                currentResult.SetAsUpdateOnSubmit();
                currentResult.RESULT_TEXT = inputText;
            }
            else
            {
                currentResult.SetAsNoChangeOnSubmit();
            }
        }
        else if (inputText != string.Empty)
        {
            SURVEY_RESULT result = new SURVEY_RESULT();
            result.RESULT_TEXT = inputText;
            result.STD_QUESTION_CHOICE_ID = availableChoices.FirstOrDefault(item => item.CHOICE_SORT_ORDER == 1).STD_QUESTION_CHOICE_ID;
            survey.SURVEY_RESULTs.Add(result);
        }
    }

    /// <summary>
    /// Save survey.
    /// </summary>
    /// <param name="survey"></param>
    private void SaveSurvey(ref SURVEY survey)
    {
        string questionNumber = "";

        calculateTotal(); // call to re-calculate total score.
        try
        {
            //first, mark all current answers for deletion
            survey.SetAsChangeTrackingRoot();
            foreach (SURVEY_RESULT tempResult in survey.SURVEY_RESULTs)
                tempResult.SetAsDeleteOnSubmit();

            SaveCustomDiagnosis(survey, questionNumber = "DX");
            SaveDate(survey, dpDate1, questionNumber = "D");
            Helpers.SaveSingleSelect(survey, rblQRPT, questionNumber = "QRPT");
            if (rblQRPT.SelectedIndex == 3) // only save this if QRPT = "Significant Other"
            {
                SaveText(survey, txtQRPT1.Text, questionNumber = "QRPT1");
            }
            Helpers.SaveSingleSelect(survey, rblQ1, questionNumber = "1");
            Helpers.SaveSingleSelect(survey, rblQ2, questionNumber = "2");
            Helpers.SaveSingleSelect(survey, rblQ3, questionNumber = "3");
            Helpers.SaveSingleSelect(survey, rblQ4, questionNumber = "4");
            Helpers.SaveSingleSelect(survey, rblQ5, questionNumber = "5");
            Helpers.SaveSingleSelect(survey, rblQ6, questionNumber = "6");
            Helpers.SaveSingleSelect(survey, rblQ7A, questionNumber = "7A");
            Helpers.SaveSingleSelect(survey, rblQ7B, questionNumber = "7B");
            Helpers.SaveSingleSelect(survey, rblQ8, questionNumber = "8");
            Helpers.SaveSingleSelect(survey, rblQ9, questionNumber = "9");
            Helpers.SaveSingleSelect(survey, rblQ10, questionNumber = "10");
            Helpers.SaveSingleSelect(survey, rblQ11, questionNumber = "11");
            Helpers.SaveSingleSelect(survey, rblQ12, questionNumber = "12");
            Helpers.SaveSingleSelect(survey, rblQ13, questionNumber = "13");
            Helpers.SaveSingleSelect(survey, rblQ14, questionNumber = "14");
            Helpers.SaveSingleSelect(survey, rblQ15, questionNumber = "15");
            Helpers.SaveSingleSelect(survey, rblQ16, questionNumber = "16");
            Helpers.SaveSingleSelect(survey, rblQ17, questionNumber = "17");
            Helpers.SaveSingleSelect(survey, rblQ18, questionNumber = "18");
            Helpers.SaveSingleSelect(survey, rblQ19, questionNumber = "19");
            Helpers.SaveSingleSelect(survey, rblQ20, questionNumber = "20");
            Helpers.SaveSingleSelect(survey, rblQ21, questionNumber = "21");
            Helpers.SaveSingleSelect(survey, rblQ22, questionNumber = "22");
            Helpers.SaveSingleSelect(survey, rblQ23, questionNumber = "23");
            Helpers.SaveSingleSelect(survey, rblQ24, questionNumber = "24");
            Helpers.SaveSingleSelect(survey, rblQ25, questionNumber = "25");
            Helpers.SaveSingleSelect(survey, rblQ26, questionNumber = "26");
            Helpers.SaveSingleSelect(survey, rblQ27, questionNumber = "27");
            if (rblQ28A.SelectedValue != "")
            {
                Helpers.SaveSingleSelect(survey, rblQ28A, questionNumber = "28A");
            }
            if (rblQ28B.SelectedValue != "")
            {
                Helpers.SaveSingleSelect(survey, rblQ28B, questionNumber = "28B");
            }
            if (rblQ28B1.SelectedValue != "")
            {
                Helpers.SaveSingleSelect(survey, rblQ28B1, questionNumber = "28B1");
            }
            Helpers.SaveSingleSelect(survey, rblQ29, questionNumber = "29");
            Helpers.SaveSingleSelect(survey, rblQ30PRE, questionNumber = "30PRE");
            Helpers.SaveSingleSelect(survey, rblQ30POST, questionNumber = "30POST");
            Helpers.SaveSingleSelect(survey, rblQ31PRE, questionNumber = "31PRE");
            Helpers.SaveSingleSelect(survey, rblQ31POST, questionNumber = "31POST");
            Helpers.SaveSingleSelect(survey, rblQ32PRE, questionNumber = "32PRE");
            Helpers.SaveSingleSelect(survey, rblQ32POST, questionNumber = "32POST");
            Helpers.SaveSingleSelect(survey, rblQ33PRE, questionNumber = "33PRE");
            Helpers.SaveSingleSelect(survey, rblQ33POST, questionNumber = "33POST");
            Helpers.SaveSingleSelect(survey, rblQ34PRE, questionNumber = "34PRE");
            Helpers.SaveSingleSelect(survey, rblQ34POST, questionNumber = "34POST");
            Helpers.SaveSingleSelect(survey, rblQ35PRE, questionNumber = "35PRE");
            Helpers.SaveSingleSelect(survey, rblQ35POST, questionNumber = "35POST");
            SaveText(survey, txtCommentsQ36.Text, questionNumber = "36");
            SaveText(survey, lblAbilitySubTotal.Text, questionNumber = "37");
            SaveText(survey, lblAdjustmentSubTotal.Text, questionNumber = "38");
            SaveText(survey, lblParticipationSubTotal.Text, questionNumber = "39");
            SaveText(survey, lblSubtotalOfSubscaleScores.Text, questionNumber = "40");
            SaveText(survey, lblSumOfScoresQ22_24.Text, questionNumber = "41");
            SaveText(survey, lblTotalScore.Text, questionNumber = "42");
            SaveText(survey, lblAbilitiesStandardScore.Text, questionNumber = "43");
            SaveText(survey, lblAdjustmentStandardScore.Text, questionNumber = "44");
            SaveText(survey, lblParticipationStandardScore.Text, questionNumber = "45");
            SaveText(survey, lblTotalStandardScore.Text, questionNumber = "46");
        }
        catch (Exception surveyEx)
        {
            Exception _tbilogerror = HandleTBIException(surveyEx, "MayoPortlandAdaptabilityInventory4.aspx", "100027", "SaveSurvey() - Question " + questionNumber);
            throw;
        }
    } // END SaveSurvey

    private void SetCustomDiagnosisElement(SURVEY_RESULT result, ASP.controls_tbidiagnosisselector_ascx diagControl)
    {
        if (result.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
        {
            diagControl.SelectedChoiceId = result.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
            if (result.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower().Contains("other"))
            {
                diagControl.SetOtherDescriptionText(result.RESULT_TEXT);
            }
        }
        else
        {
            diagControl.SelectedChoiceId = null;
        }
    }

    private void SetDateElement(SURVEY_RESULT result, Telerik.Web.UI.RadDatePicker date)
    {
        if (!String.IsNullOrEmpty(result.RESULT_TEXT))
        {
            DateTime temp;
            if (DateTime.TryParse(result.RESULT_TEXT, out temp))
            {
                date.SelectedDate = temp;
            }
        }
    }

    private void SetLabelElement(SURVEY_RESULT result, Label label)
    {
        if (result.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
        {
            label.Text = BusinessHelper.FixStringToPreventXss(result.RESULT_TEXT);
        }
    }

    private void SetRadioElement(SURVEY_RESULT result, RadioButtonList radioButton)
    {
        if (result.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
        {
            radioButton.SelectedValue = result.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
        }
        else
        {
            radioButton.SelectedIndex = -1;
        }
    }

    private void SetTextBoxElement(SURVEY_RESULT survey, TextBox textBox)
    {
        textBox.Text = survey.RESULT_TEXT;
    }

    /// <summary>
    /// Initialize/setup controls
    /// </summary>
    /// <param name="survey"></param>
    private void SetUpSurvey(SURVEY survey)
    {
        try
        {
            foreach (var sResult in survey.SURVEY_RESULTs)
            {
                switch (sResult.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER)
                {
                    case "DX": SetCustomDiagnosisElement(sResult, ctrlDiagnosis); break;
                    case "D": SetDateElement(sResult, dpDate1); break;
                    case "QRPT": SetRadioElement(sResult, rblQRPT); break;
                    case "QRPT1": SetTextBoxElement(sResult, txtQRPT1); break;
                    case "1": SetRadioElement(sResult, rblQ1); break;
                    case "2": SetRadioElement(sResult, rblQ2); break;
                    case "3": SetRadioElement(sResult, rblQ3); break;
                    case "4": SetRadioElement(sResult, rblQ4); break;
                    case "5": SetRadioElement(sResult, rblQ5); break;
                    case "6": SetRadioElement(sResult, rblQ6); break;
                    case "7A": SetRadioElement(sResult, rblQ7A); break;
                    case "7B": SetRadioElement(sResult, rblQ7B); break;
                    case "8": SetRadioElement(sResult, rblQ8); break;
                    case "9": SetRadioElement(sResult, rblQ9); break;
                    case "10": SetRadioElement(sResult, rblQ10); break;
                    case "11": SetRadioElement(sResult, rblQ11); break;
                    case "12": SetRadioElement(sResult, rblQ12); break;
                    case "13": SetRadioElement(sResult, rblQ13); break;
                    case "14": SetRadioElement(sResult, rblQ14); break;
                    case "15": SetRadioElement(sResult, rblQ15); break;
                    case "16": SetRadioElement(sResult, rblQ16); break;
                    case "17": SetRadioElement(sResult, rblQ17); break;
                    case "18": SetRadioElement(sResult, rblQ18); break;
                    case "19": SetRadioElement(sResult, rblQ19); break;
                    case "20": SetRadioElement(sResult, rblQ20); break;
                    case "21": SetRadioElement(sResult, rblQ21); break;
                    case "22": SetRadioElement(sResult, rblQ22); break;
                    case "23": SetRadioElement(sResult, rblQ23); break;
                    case "24": SetRadioElement(sResult, rblQ24); break;
                    case "25": SetRadioElement(sResult, rblQ25); break;
                    case "26": SetRadioElement(sResult, rblQ26); break;
                    case "27": SetRadioElement(sResult, rblQ27); break;
                    case "28A": SetRadioElement(sResult, rblQ28A); break;
                    case "28B": SetRadioElement(sResult, rblQ28B); break;
                    case "28B1": SetRadioElement(sResult, rblQ28B1); break;
                    case "29": SetRadioElement(sResult, rblQ29); break;
                    case "30PRE": SetRadioElement(sResult, rblQ30PRE); break;
                    case "30POST": SetRadioElement(sResult, rblQ30POST); break;
                    case "31PRE": SetRadioElement(sResult, rblQ31PRE); break;
                    case "31POST": SetRadioElement(sResult, rblQ31POST); break;
                    case "32PRE": SetRadioElement(sResult, rblQ32PRE); break;
                    case "32POST": SetRadioElement(sResult, rblQ32POST); break;
                    case "33PRE": SetRadioElement(sResult, rblQ33PRE); break;
                    case "33POST": SetRadioElement(sResult, rblQ33POST); break;
                    case "34PRE": SetRadioElement(sResult, rblQ34PRE); break;
                    case "34POST": SetRadioElement(sResult, rblQ34POST); break;
                    case "35PRE": SetRadioElement(sResult, rblQ35PRE); break;
                    case "35POST": SetRadioElement(sResult, rblQ35POST); break;
                    case "36": SetTextBoxElement(sResult, txtCommentsQ36); break;
                    case "37": SetLabelElement(sResult, lblAbilitySubTotal); break;
                    case "38": SetLabelElement(sResult, lblAdjustmentSubTotal); break;
                    case "39": SetLabelElement(sResult, lblParticipationSubTotal); break;
                    case "40": SetLabelElement(sResult, lblSubtotalOfSubscaleScores); break;
                    case "41": SetLabelElement(sResult, lblSumOfScoresQ22_24); break;
                    case "42": SetLabelElement(sResult, lblTotalScore); break;
                    case "43": SetLabelElement(sResult, lblAbilitiesStandardScore); break;
                    case "44": SetLabelElement(sResult, lblAdjustmentStandardScore); break;
                    case "45": SetLabelElement(sResult, lblParticipationStandardScore); break;
                    case "46": SetLabelElement(sResult, lblTotalStandardScore); break;
                    default: break;
                }
            }
        }
        catch (Exception ex)
        {
            Exception _tbilogerror = HandleTBIException(ex, "MayoPortlandAdaptabilityInventory4.aspx", "100027", "SetUpSurvey()");
        }
    }// END SetUpSurvey

    #endregion
}
